/*
	File:		DialogWindow.cp

	Contains:	Dialog example using Appearance Manager primitives.

	Version:	Appearance 1.0 SDK

	Copyright:	 1997 by Apple Computer, Inc., all rights reserved.

	File Ownership:

		DRI:				Edward Voas

		Other Contact:		7 of 9, Borg Collective

		Technology:			OS Technologies Group

	Writers:

		(edv)	Ed Voas

	Change History (most recent first):

		 <1>	 9/11/97	edv		First checked in.
*/

#include <MacWindows.h>
#include "DialogWindow.h"
#include "Appearance.h"
#include "ColorPenState.h"

DialogWindow::DialogWindow() : BaseWindow( 129 )
{
	::SetThemeWindowBackground( fWindow, kThemeActiveDialogBackgroundBrush, true );
}

DialogWindow::~DialogWindow()
{
}

//
//	 Activate
//
//	Activate our window by drawing all of our items in the active state.
//
void
DialogWindow::Activate( EventRecord& )
{
	Rect				editTextRect = { 9, 9, 27, 101 };

	::SetPort( fWindow );
	::DrawThemeModelessDialogFrame( &fWindow->portRect, kThemeStateActive );
	DrawFakeEditText( kThemeStateActive );
	DrawFakeListBox( kThemeStateActive );
	DrawGroups( kThemeStateActive );
	DrawSeparators( kThemeStateActive );
	::DrawThemeFocusRect( &editTextRect, true );
}

//
//	 Deactivate
//
//	Deactivate our window by drawing all of our items in the inactive state.
//
void
DialogWindow::Deactivate( EventRecord& )
{
	Rect		rect = fWindow->portRect;
	Rect		editTextRect = { 9, 9, 27, 101 };
	
	::SetPort( fWindow );
	::DrawThemeModelessDialogFrame( &fWindow->portRect, kThemeStateDisabled );
	DrawFakeEditText( kThemeStateDisabled );
	DrawFakeListBox( kThemeStateDisabled );
	DrawGroups( kThemeStateDisabled );
	DrawSeparators( kThemeStateDisabled );
	::DrawThemeFocusRect( &editTextRect, false );
}

//
//	 Draw
//
//	Draws our dialog frame, edit text, list box, group box frames, as well as visual
//	separators.
//
void
DialogWindow::Draw()
{
	::SetPort( fWindow );

	::DrawThemeModelessDialogFrame( &fWindow->portRect,
		((WindowPeek)fWindow)->hilited ? kThemeStateActive : kThemeStateDisabled );
	DrawFakeEditText( ((WindowPeek)fWindow)->hilited ? kThemeStateActive : kThemeStateDisabled );
	DrawFakeListBox( ((WindowPeek)fWindow)->hilited ? kThemeStateActive : kThemeStateDisabled );
	DrawGroups( ((WindowPeek)fWindow)->hilited ? kThemeStateActive : kThemeStateDisabled );
	DrawSeparators( ((WindowPeek)fWindow)->hilited ? kThemeStateActive : kThemeStateDisabled );
}

//
//	 DrawFakeEditText
//
//	Draws a mock-up of an edit text box. Note that the edit text frame can actually
//	be drawn outside of the rectangle given. You essentially pass it the content
//	rectangle and it figures out where the frame and bevel should be.
//
void
DialogWindow::DrawFakeEditText( ThemeDrawState drawState )
{
	Rect				editTextRect = { 10, 10, 26, 100 };
	ColorPenState		state;
	
	::SetPort( fWindow );
	
	::GetColorAndPenState( &state );
	::NormalizeColorAndPen();
	
	::EraseRect( &editTextRect );
	::DrawThemeEditTextFrame( &editTextRect, drawState );
	
	::InsetRect( &editTextRect, -1, -1 );
	::DrawThemeFocusRect( &editTextRect, ((WindowPeek)fWindow)->hilited );
	::SetColorAndPenState( &state );
}

//
//	 DrawFakeListBox
//
//	Draws a mock-up of an list box. Note that the list frame can actually
//	be drawn outside of the rectangle given. You essentially pass it the content
//	rectangle and it figures out where the frame and bevel should be.
//
void
DialogWindow::DrawFakeListBox( ThemeDrawState drawState )
{
	Rect				editTextRect = { 36, 10, 100, 100 };
	ColorPenState		state;
	
	::SetPort( fWindow );
	
	::GetColorAndPenState( &state );
	::NormalizeColorAndPen();
	
	::EraseRect( &editTextRect );
	::DrawThemeListBoxFrame( &editTextRect, drawState );
	::SetColorAndPenState( &state );
}

//
//	 DrawGroups
//
//	Draws a primary and secondary group box.
//
void
DialogWindow::DrawGroups( ThemeDrawState drawState )
{
	Rect		primaryRect = { 10, 110, 110, 210 };
	Rect		secondaryRect = { 20, 120, 100, 200 };
	
	::DrawThemePrimaryGroup( &primaryRect, drawState );
	::DrawThemeSecondaryGroup( &secondaryRect, drawState );
}

//
//	 DrawSeparators
//
//	Simple visual separators
//
void
DialogWindow::DrawSeparators( ThemeDrawState drawState )
{
	Rect		vertRect = { 120, 110, 125, 210 };
	Rect		horizRect = { 10, 220, 110, 225 };
	
	::DrawThemeSeparator( &vertRect, drawState );
	::DrawThemeSeparator( &horizRect, drawState );
}

